<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Events\LessonCompletedEvent;
use Illuminate\Support\Facades\Log;

class VideoProgress extends Model
{
    protected $table = 'video_progress';
    protected $primaryKey = 'Progress_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Lesson_id',
        'Watched_duration',
        'Last_position',
        'Is_completed',
        'Interactive_elements_completed',
        'Assignment_id',
        'Last_activity',
        'Total_attempts',
        'Completion_status',
        'Total_duration',
        'Completed_at',
    ];

    protected $casts = [
        'Is_completed' => 'boolean',
        'Interactive_elements_completed' => 'integer',
        'Watched_duration' => 'integer',
        'Last_position' => 'integer',
        'Total_attempts' => 'integer',
        'Total_duration' => 'integer',
        'Last_activity' => 'datetime',
        'Completed_at' => 'datetime',
        'Completion_status' => 'string',
    ];

    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'Lesson_id', 'Lesson_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::updated(function ($videoProgress) {
            if ($videoProgress->isDirty('Is_completed') && $videoProgress->Is_completed) {
                Log::info('Lesson completed event triggered', [
                    'Progress_id' => $videoProgress->Progress_id,
                    'User_id' => $videoProgress->User_id,
                    'Lesson_id' => $videoProgress->Lesson_id,
                    'Is_completed' => $videoProgress->Is_completed,
                ]);
                event(new LessonCompletedEvent($videoProgress));
            }
        });
    }
}
